class MSRestarterMutator extends Mutator Config(MSAdjuster);

var config localized string DefaultMapName;

var float CheckTime, TimeSince;
var config string lastmapname;

var config bool bUseDefaultMap;

var config string MapNames[50];
var config string FileNames[50];

function Mutate(string S, PlayerPawn Player)
{
        Super.Mutate(S, Player);
}

function PostBeginPlay()
{   
	Level.Game.BaseMutator.AddMutator(Self);
	Level.Game.RegisterDamageMutator(Self);
        SetTimer(1, False);
}

function String TranslateMap(string Inp)
{
 local int i, IndNum;
 
 for(i=0; i<50; i++)
 {
  if (Inp ~= MapNames[i])
  {
   IndNum = i;
   break;
  }
  else if (Inp != MapNames[i] && (i == 49 || i == 50) )
  {
   return DefaultMapName;
  }
 }
 
 return FileNames[IndNum];
}

function Timer()
{
 local DeusExLevelInfo immafindyou;
 local DeusExMPGame immasetyou;

 ForEach AllActors(class'DeusExLevelInfo', immafindyou) 
 {
  if (immafindyou != None)
  {
   if (immafindyou.mapname ~= "DX")
   {
    if (bUseDefaultMap || lastmapname ~= "")
     Level.ServerTravel(DefaultMapName, False);

    else if (!bUseDefaultMap && lastmapname != "")
     Level.ServerTravel( TranslateMap(lastmapname), False);
   }
  }
  else
   log("ERROR MSRESTARTER CANNOT FIND DEUSEXLEVELINFO!");
 }

}

function Tick(float Deltatime)
{
 local DeusExLevelInfo immafindyou;

 if (!bUseDefaultMap)
 {
  if (TimeSince > 0)
   TimeSince -= DeltaTime;
  if (TimeSince < 0)
  {
   TimeSince = CheckTime;
	 ForEach AllActors(class'DeusExLevelInfo', immafindyou) 
	 {
 	  if (immafindyou != None)
 	  {
 	   if (immafindyou.mapname != "DX" && immafindyou.mapname != "dx" && immafindyou.mapname != "Dx" && immafindyou.mapname != "dX")
 	   {
	    lastmapname = immafindyou.mapname;
	    SaveConfig();
 	   }
 	  }
 	 }
  }
 }
 
 Super.Tick(Deltatime);
}

defaultproperties
{
 bUseDefaultMap=False
 CheckTime=3.000000
}
